<?php
// 1. LOGIC PHP (JANGAN DIUBAH)
$jml_siswa = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM siswa WHERE status='Aktif'"));
$jml_guru  = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM guru"));
$d_kelas   = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT COUNT(DISTINCT kelas) as tot FROM siswa"));
$jml_kelas = $d_kelas['tot'];
$d_uang    = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT SUM(jumlah) as tot FROM spp WHERE status='Lunas'"));
$uang      = $d_uang['tot'] ?? 0;

// Grafik
$qg = mysqli_query($koneksi, "SELECT kelas, COUNT(*) as jumlah FROM siswa GROUP BY kelas");
$arr_s = []; while($r=mysqli_fetch_assoc($qg)) $arr_s[]="['$r[kelas]', $r[jumlah]]";
$str_siswa = implode(",", $arr_s);

$qgm = mysqli_query($koneksi, "SELECT mapel, COUNT(*) as jumlah FROM guru GROUP BY mapel");
$arr_g = []; while($r=mysqli_fetch_assoc($qgm)) $arr_g[]="['$r[mapel]', $r[jumlah]]";
$str_guru = implode(",", $arr_g);
?>

<!-- STYLE KHUSUS HALAMAN INI -->
<style>
    /* Gradient Colors */
    .bg-gradient-blue { background: linear-gradient(45deg, #0d6efd, #0dcaf0); }
    .bg-gradient-green { background: linear-gradient(45deg, #198754, #20c997); }
    .bg-gradient-red { background: linear-gradient(45deg, #dc3545, #fd7e14); }
    .bg-gradient-yellow { background: linear-gradient(45deg, #ffc107, #ffca2c); color: #333; }
    
    /* Card Hover Effect */
    .stat-card { transition: transform 0.3s ease, box-shadow 0.3s ease; border: none; overflow: hidden; }
    .stat-card:hover { transform: translateY(-5px); box-shadow: 0 10px 20px rgba(0,0,0,0.15) !important; }
    
    /* Big Icon Background */
    .bg-icon {
        position: absolute;
        right: -10px;
        bottom: -10px;
        font-size: 5rem;
        opacity: 0.2;
        transform: rotate(-15deg);
    }
</style>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-bold text-dark">Dashboard Overview</h2>
    <span class="text-muted"><i class="bi bi-calendar-event me-1"></i> <?= date('d F Y') ?></span>
</div>

<!-- KARTU STATISTIK (MODERN) -->
<div class="row g-4 mb-4">
    
    <!-- SISWA -->
    <div class="col-md-3">
        <div class="card stat-card bg-gradient-blue text-white shadow rounded-4 h-100 p-3">
            <div class="d-flex justify-content-between align-items-center position-relative z-1">
                <div>
                    <h6 class="text-uppercase small fw-bold opacity-75">Siswa Aktif</h6>
                    <h2 class="display-6 fw-bold mb-0"><?= $jml_siswa ?></h2>
                </div>
            </div>
            <i class="bi bi-people-fill bg-icon text-white"></i>
        </div>
    </div>

    <!-- GURU -->
    <div class="col-md-3">
        <div class="card stat-card bg-gradient-green text-white shadow rounded-4 h-100 p-3">
            <div class="d-flex justify-content-between align-items-center position-relative z-1">
                <div>
                    <h6 class="text-uppercase small fw-bold opacity-75">Guru & Staff</h6>
                    <h2 class="display-6 fw-bold mb-0"><?= $jml_guru ?></h2>
                </div>
            </div>
            <i class="bi bi-person-badge-fill bg-icon text-white"></i>
        </div>
    </div>

    <!-- KELAS -->
    <div class="col-md-3">
        <div class="card stat-card bg-gradient-red text-white shadow rounded-4 h-100 p-3">
            <div class="d-flex justify-content-between align-items-center position-relative z-1">
                <div>
                    <h6 class="text-uppercase small fw-bold opacity-75">Total Kelas</h6>
                    <h2 class="display-6 fw-bold mb-0"><?= $jml_kelas ?></h2>
                </div>
            </div>
            <i class="bi bi-building-fill bg-icon text-white"></i>
        </div>
    </div>

    <!-- UANG -->
    <div class="col-md-3">
        <div class="card stat-card bg-gradient-yellow shadow rounded-4 h-100 p-3">
            <div class="d-flex justify-content-between align-items-center position-relative z-1">
                <div>
                    <h6 class="text-uppercase small fw-bold text-dark opacity-75">Uang Masuk</h6>
                    <h2 class="fw-bold mb-0 text-dark">Rp <?= number_format($uang/1000, 0) ?>k</h2>
                </div>
            </div>
            <i class="bi bi-wallet-fill bg-icon text-dark"></i>
        </div>
    </div>
</div>

<!-- AREA GRAFIK & PENGUMUMAN -->
<div class="row g-4">
    
    <!-- Grafik Siswa -->
    <div class="col-md-4">
        <div class="card border-0 shadow rounded-4 h-100">
            <div class="card-header bg-white border-0 pt-3 ps-3">
                <h6 class="fw-bold m-0"><i class="bi bi-pie-chart-fill text-primary me-2"></i>Statistik Siswa</h6>
            </div>
            <div class="card-body">
                <div id="chart_siswa" style="width:100%; height:250px;"></div>
            </div>
        </div>
    </div>

    <!-- Grafik Guru -->
    <div class="col-md-4">
        <div class="card border-0 shadow rounded-4 h-100">
            <div class="card-header bg-white border-0 pt-3 ps-3">
                <h6 class="fw-bold m-0"><i class="bi bi-pie-chart-fill text-success me-2"></i>Statistik Guru</h6>
            </div>
            <div class="card-body">
                <?php if($str_guru){ ?>
                    <div id="chart_guru" style="width:100%; height:250px;"></div>
                <?php } else { echo "<div class='d-flex align-items-center justify-content-center h-100 text-muted'>Belum ada data</div>"; } ?>
            </div>
        </div>
    </div>

    <!-- Pengumuman (Desain Baru) -->
    <div class="col-md-4">
        <div class="card border-0 shadow rounded-4 h-100">
            <div class="card-header bg-white border-0 pt-3 ps-3 d-flex justify-content-between align-items-center">
                <h6 class="fw-bold m-0"><i class="bi bi-megaphone-fill text-danger me-2"></i>Pengumuman</h6>
                <?php if($_SESSION['role_admin'] == 'Admin') { ?>
        <button class="btn btn-sm btn-light rounded-circle shadow-sm" data-bs-toggle="modal" data-bs-target="#mPengumuman">
            <i class="bi bi-plus text-primary"></i>
        </button>
    <?php } ?>
            </div>
            <div class="card-body p-2 overflow-auto" style="max-height: 280px;">
                <ul class="list-group list-group-flush">
                    <?php
                    $qp = mysqli_query($koneksi, "SELECT * FROM pengumuman ORDER BY id DESC LIMIT 4");
                    if(mysqli_num_rows($qp) > 0){
                        while($p = mysqli_fetch_array($qp)){
                            $border = 'border-start border-4 border-primary';
                            if($p['jenis']=='Penting') $border = 'border-start border-4 border-danger';
                            if($p['jenis']=='Libur') $border = 'border-start border-4 border-success';
                    ?>
                        <li class="list-group-item border-0 mb-2 shadow-sm rounded bg-light <?= $border ?> ps-3">
                            <div class="d-flex w-100 justify-content-between">
                                <h6 class="mb-1 fw-bold text-dark"><?= $p['judul']; ?></h6>
                                <small class="text-muted" style="font-size:10px"><?= date('d M', strtotime($p['tanggal'])); ?></small>
                            </div>
                            <p class="mb-1 small text-secondary lh-sm"><?= $p['isi']; ?></p>
                            <?php if($_SESSION['role_admin'] == 'Admin') { ?>
        <a href="proses/act_pengumuman.php?aksi=hapus&id=<?= $p['id']; ?>" class="text-danger small text-decoration-none" onclick="return confirm('Hapus?')">
            <i class="bi bi-trash"></i> Hapus
        </a>
    <?php } ?>
                        </li>
                    <?php 
                        } 
                    } else {
                        echo "<div class='text-center mt-5 text-muted'><i class='bi bi-inbox fs-1'></i><br>Tidak ada info baru.</div>";
                    }
                    ?>
                </ul>
            </div>
        </div>
    </div>

</div>

<!-- Modal Pengumuman (Sama) -->
<div class="modal fade" id="mPengumuman">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="proses/act_pengumuman.php">
                <div class="modal-header"><h5>Buat Pengumuman</h5></div>
                <div class="modal-body">
                    <input name="judul" class="form-control mb-2" placeholder="Judul" required>
                    <select name="jenis" class="form-select mb-2"><option value="Info">Info</option><option value="Penting">Penting</option><option value="Libur">Libur</option></select>
                    <textarea name="isi" class="form-control" rows="3" placeholder="Isi..." required></textarea>
                </div>
                <div class="modal-footer"><button type="submit" name="simpan_pengumuman" class="btn btn-primary">Posting</button></div>
            </form>
        </div>
    </div>
</div>

<!-- Scripts Chart -->
<script src="https://www.gstatic.com/charts/loader.js"></script>
<script>
    google.charts.load('current', {'packages':['corechart']});
    google.charts.setOnLoadCallback(function(){
        <?php if($str_siswa){ ?> 
        new google.visualization.PieChart(document.getElementById('chart_siswa')).draw(
            google.visualization.arrayToDataTable([['K','J'],<?= $str_siswa ?>]),
            {pieHole:0.5, colors: ['#0d6efd', '#6610f2', '#6f42c1'], legend:'bottom', chartArea:{width:'90%',height:'80%'}}
        ); 
        <?php } ?>
        <?php if($str_guru){ ?> 
        new google.visualization.PieChart(document.getElementById('chart_guru')).draw(
            google.visualization.arrayToDataTable([['M','J'],<?= $str_guru ?>]),
            {pieHole:0.5, colors: ['#198754', '#20c997', '#ffc107', '#fd7e14'], legend:'bottom', chartArea:{width:'90%',height:'80%'}}
        ); 
        <?php } ?>
    });
</script>